<?php
require_once("classes/factory.class.php");

abstract class Record {
	private $m_campi;
	private $m_tipi;
	private $m_dimensioni;
	protected $m_changed; # dice se il record e' cambiato.
	protected $m_tabella;
	protected $m_identity;
	private $m_campi_changed; # per ogni campo del record, dice se e' cambiato.
	private $m_last_query;
	protected $m_codice_classe;
	protected $m_voce_tipologia;
	private $m_metainfo; # metaoggetto
	protected $m_last_message; # messaggio

	protected $m_campo_tipologia;
	protected $m_codice_tipologia;

	private $m_init;

	#private $m_sysrecord;
	protected $m_own_save; # messaggio
	protected $m_eludi_check;

	protected $m_last_action; # ultima azione {I, U, D}


	################################################
	# Costruttore.
	public function __construct() {
		$this->m_init = false;

		$this->m_campi = array();
		$this->m_tipi = array();
		$this->m_dimensioni = array();
		$this->m_changed = false;
		$this->m_campi_changed = array();
		$this->m_last_message = new Messaggio();

		$this->m_codice_classe = "";
		$this->m_own_save = true;
		$this->m_eludi_check = false;
	}

	################################################
	# CHECK
	protected function checkCampo($chiave) {
		$chiave = strtolower($chiave);

		return array_key_exists($chiave, $this->m_campi);
	}

	################################################
	# GET
	public function id() {
		if (isset($this->m_identity))
			return $this->m_campi[$this->m_identity];
		return null;
	}
	public function code() {
		if ($this->checkCampo("code"))
			return $this->m_campi["code"];
		return $this->id();
	}
	public function isChanged($chiave=null) {
		if (is_null($chiave))
			return $this->m_changed;
		elseif ($this->checkCampo($chiave))
			return $this->m_campi_changed[$chiave];
	}
	public function get($chiave) {
		$chiave = strtolower($chiave);

		if ($this->checkCampo($chiave))
			return $this->m_campi[$chiave];
	}
	public function metainfo() {
		return $this->m_metainfo;
	}
	public function identity() {
		return $this->m_identity;
	}
	#-----------------------------------------------
	public function campi() {
		return $this->m_campi;
	}
	public function tipi() {
		return $this->m_tipi;
	}
	public function tipo($chiave) {
		if ($this->checkCampo($chiave))
			return $this->m_tipi[$chiave];
		else
			return "";
	}
	public function lastQuery() {
		return $this->m_last_query;
	}
	public function lastMessage() {
		return $this->m_last_message;
	}
	public function dimensioni($chiave) {
		if ($this->checkCampo($chiave))
			return $this->m_dimensioni[$chiave];
		else
			return -1;
	}

	public function campotipologia() {
    return $this->m_campo_tipologia;
  }

	public function tabella() {
    return $this->m_tabella;
  }
	public function voceTipologia() {
		return $this->m_voce_tipologia;
	}

	################################################
	# GET SYSRECORD
	public function sysrecord() {
		#return $this->m_sysrecord;
		$oggetto = Factory::crea("SYSRecord", $this->code());
		$oggetto->set("tabella", $this->m_tabella);
		$oggetto->set("classe", get_class($this));
		if (strlen($this->code()) == 0) {
			$code = substr(strtoupper(get_class($this).substr(md5(microtime()), rand(0, 8), 24)), 0, 50);
			$this->set("code", $code);
			$oggetto->set("code", $code);
			Factory::memorizza($this);
		}
		elseif (strlen($oggetto->code()) == 0){
			$oggetto->set("code", $this->code());
		}
		Factory::memorizza($oggetto);
		return $oggetto;
	}
	public function modificabile() {
		#GLOBAL $metautente;

		#if ($this->m_campi["modificabile"] == 'S')
		#if ($metautente->amministratore())
		#	return true;
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			if ($sysrecord->get("modificabile") == 'N')
				return false;
		return true;
	}
	public function attivo() {
		#if ($this->m_campi["attivo"] == 'S')
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			if ($sysrecord->get("attivo") == 'N')
				return false;
		return true;
	}
	public function start() {
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			return $sysrecord->get("start");
	}
	public function stop() {
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			return $sysrecord->get("stop");
	}
	public function ownSave() {
		return $this->m_own_save;
	}
	################################################
	# SET
	public function set($chiave, $valore) {
		$chiave = strtolower($chiave);

		#if (is_null($valore))
		#	return true;
		if (!$this->checkCampo($chiave))
			return false;
		if (!is_object($valore))
			if ($this->m_campi[$chiave] == $valore)
				return true;
		$this->m_campi[$chiave] = $valore;
		$this->m_changed = true;
		$this->m_campi_changed[$chiave] = true;
		return true;
	}
	public function setVoceTipologia($vocetipologia) {
		if (is_object($vocetipologia)) {
			$this->m_voce_tipologia = $vocetipologia;
		}
		else {
			$voce = new MetaVoceTipologia();
			$voce->load($vocetipologia);
			$this->m_voce_tipologia = $voce;
		}
 		return $this->updateMetaInfo();
	}
	public function setMetaInfo($metainfo) {
		if (is_object($metainfo))
			$this->m_metainfo = $metainfo;
	}
	public function setIdentity($identity) {
		if (!$this->checkCampo($identity))
			return false;
		$this->m_identity = $identity;
	}

	public function setTabella($tabella) {
		$this->m_tabella = $tabella;
	}

	public function setLastMessage($msg) {
			$this->m_last_message = $msg;
			return true;
	}
	public function setStart($data) {
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			$sysrecord->set("start", $data);
		else
			die("START:: SYSRECORD NON E' OBJECT!!!");
		$this->m_changed = true;
		Factory::memorizza($sysrecord);
	}
	public function setStop($data) {
		$sysrecord = $this->sysrecord();
		if (is_object($sysrecord))
			$sysrecord->set("stop", $data);
		else
			die("STOP:: SYSRECORD NON E' OBJECT!!!");
		$this->m_changed = true;
		Factory::memorizza($sysrecord);
	}
	public function setEludiCheck($bool) {
			$this->m_eludi_check = $bool;
			return true;
	}

	public function setCode($code="") {
		# genero il CODE:
		if (strlen($this->get("code")) <= 0) {
			if (strlen($code) > 0)
				$this->set("code", $code);
			else
				$this->set("code", substr(strtoupper(get_class($this).substr(md5(microtime()), rand(0, 8), 24)), 0, 50));
		}
		return true;
	}



	################################################
	# INIT.
	public function init($cache=true) {
		GLOBAL $db;

		if ($this->m_init)
			return true;

		if (is_null($db))
			return false;


		#---------------------------------------------------------------------------
		# Vediamo se in cache c'e' qualcosa...
		if ($cache && isset($_SESSION["CACHE"][get_class($this)])) {
			if (is_array($_SESSION["CACHE"][get_class($this)]["CAMPI"]))
				$this->m_campi = $_SESSION["CACHE"][get_class($this)]["CAMPI"];
			if (is_array($_SESSION["CACHE"][get_class($this)]["TIPI"]))
				$this->m_tipi = $_SESSION["CACHE"][get_class($this)]["TIPI"];
			if (is_array($_SESSION["CACHE"][get_class($this)]["CAMPI_CHANGED"]))
				$this->m_campi_changed = $_SESSION["CACHE"][get_class($this)]["CAMPI_CHANGED"];
			if (is_array($_SESSION["CACHE"][get_class($this)]["DIMENSIONI"]))
				$this->m_dimensioni = $_SESSION["CACHE"][get_class($this)]["DIMENSIONI"];

			$this->m_changed = false;
			$this->m_init = true;
			return true;
		}


		#---------------------------------------------------------------------------
		# Andiamo allora a leggerli dal db...
		if ((DB_TYPE == "mssql") || (DB_TYPE == "sybase")) {
			$strSQL = "SELECT TOP 1 * FROM ".$this->m_tabella;
			$rs = $db->Esegui($strSQL, false);

			if ($rs == false)
				return false;

			$metacol = $db->link->MetaColumns($this->m_tabella);

			$numfields = $rs->FieldCount();
			for ($f=0; $f<$numfields; $f++) {
				$field = $rs->FetchField($f);
				$nomecampo = strtolower($field->name);
				$this->m_campi[$nomecampo] = null;
				$this->m_tipi[$nomecampo] = $field->type;
				$this->m_campi_changed[$nomecampo] = false;

				$metafield = $metacol[strtoupper($nomecampo)];
				switch ($field->type) {
					case "text":
						$this->m_dimensioni[$nomecampo] = $metafield->max_length*1024;
						break;

					default:
						$this->m_dimensioni[$nomecampo] = $metafield->max_length;#$field->max_length;
						break;
				}

				if ($this->m_dimensioni[$nomecampo] <= 0)
					$this->m_dimensioni[$nomecampo] = $field->max_length;
			}
		}
		elseif (DB_TYPE == "pgsql") {
			$strSQL = "SELECT a.attname AS name, t.typname AS type, a.attstorage AS i,
								CASE WHEN a.attlen = -1 THEN a.atttypmod ELSE a.attlen END AS size
								FROM pg_attribute a , pg_class c, pg_type t
								WHERE c.relname = '".$this->m_tabella."'
								AND a.attrelid = c.oid AND a.atttypid = t.oid and a.attnum > 0 and not a.attisdropped";
			$rs = $db->Esegui($strSQL);

			if ($rs == false)
				return false;

			while (!$rs->EOF) {
				$name = $rs->Fields("name");
				$this->m_campi[$name] = null;
				$this->m_campi_changed[$name] = false;
				switch ($rs->Fields("type")) {
					case "int4":
						$this->m_tipi[$name] = "int4";
						$this->m_dimensioni[$name] = $rs->Fields("size");
						break;

					case "text":
						$this->m_tipi[$name] = "text";
						$this->m_dimensioni[$name] = 64*1024;
						break;

					default:
						$this->m_tipi[$name] = $rs->Fields("type");
						$this->m_dimensioni[$name] = $rs->Fields("size") - 4;
						break;
				}
				$rs->MoveNext();
			}
		}

		#---------------------------------------------------------------------------
		# Metto in cache...
		$_SESSION["CACHE"][get_class($this)]["CAMPI"] = $this->m_campi;
		$_SESSION["CACHE"][get_class($this)]["TIPI"] = $this->m_tipi;
		$_SESSION["CACHE"][get_class($this)]["CAMPI_CHANGED"] = $this->m_campi_changed;
		$_SESSION["CACHE"][get_class($this)]["DIMENSIONI"] = $this->m_dimensioni;

		$this->m_changed = false;
		$this->m_init = true;
		return true;
	}

	################################################
	# LOAD.
	public function load($id) {
		GLOBAL $db;

		#if (DB_TYPE == "pgsql")
			$this->init();

		if (is_null($db))
			return false;

		#--------------------------------------------------
		if (is_array($id)) {
			$strSQL = "SELECT * FROM ".$this->m_tabella;
			if (count($id) > 0)
					$strSQL .= " WHERE ";
			foreach($id as $key => $value) {
				if ($this->checkCampo($key)) {
					$this->set($key, $value);
					$strSQL .= $key."=".$this->quota($key)." AND ";
				}
			}
			$strSQL = substr($strSQL, 0, -5);
		}
		else {
			if (strlen($id) <= 0)
				return false;
			$this->set($this->m_identity, $id);
			$strSQL = "SELECT * FROM ".$this->m_tabella." WHERE ".$this->m_identity."=".$this->quota($this->m_identity);
		}
		#--------------------------------------------------
		$rs = $db->Esegui($strSQL);

		if ($rs == false)
			return false;

		if ($rs->RecordCount() > 0)
			$this->loadFromRecord($rs);
		return $rs->RecordCount();
	}
	public function loadFromCode($code) {
		GLOBAL $db;

		$this->init();

		if (is_null($db) || (strlen($code) <= 0))
			return false;

		/*$strSQL = "SELECT t.*, r.attivo, r.modificabile, r.ui, r.ti, r.uu, r.tu, r.ud, r.td FROM ".$this->m_tabella." t ".
							"JOIN sys_record r ON r.code=t.code ".
							"AND t.code=".quote_string($code, true);
		$rs = $db->Esegui($strSQL);

		if ($rs == false)
			return false;

		$this->loadFromRecord($rs);
		$rs->Close();*/

		#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		# PRIMA CARICO LA TABELLA
		$strSQL = "SELECT t.* FROM ".$this->m_tabella." t ".
							"WHERE t.code=".quote_string($code, true);
		$rs = $db->Esegui($strSQL);

		if ($rs == false)
			return false;

		$this->loadFromRecord($rs);
		$rs->Close();

		#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		# E POI LA SYS_RECORD
		$sysrecord = Factory::crea("SYSRecord", $code);
		Factory::memorizza($sysrecord);
		return true;
	}
	public function loadFromRecord($rs) {
		GLOBAL $db;
		
		if (is_null($rs))
			return false;

		#$metacol = $db->link->MetaColumns($this->m_tabella);

		$numfields = $rs->FieldCount();
		for ($f=0; $f<$numfields; $f++) {
			$field = $rs->FetchField($f);
			$nomecampo = strtolower($field->name);
			#DEBUG($field->name." = ".$rs->Fields($field->name));
			$this->m_campi[$nomecampo] = $rs->Fields($field->name);
			$this->m_tipi[$nomecampo] = $field->type;
			$this->m_campi_changed[$nomecampo] = false;
			/*if (DB_TYPE == "mssql") {
				$metafield = $metacol[strtoupper($nomecampo)];
				$this->m_dimensioni[$nomecampo] = $metafield->max_length;#$field->max_length;
			}*/
		}

		$this->m_changed = false;
		return true;
	}
	public function loadInput($oggetto, $messaggio, $voce_tipologia=null, $pre="", $post="") {
		GLOBAL $metautente;

		if (is_object($this->metainfo()))
			$oggetto = $this->metainfo();

		if (!is_object($oggetto)) {
			$messaggio->setTipo(MSG_ERROR);
			$messaggio->setMessaggio("ATTENZIONE!<br />Oggetto NON configurato. (".get_class($this).")");
			return false;
		}

		$ruolo = $metautente->ruolo();
		$res = true;

		#---------------------------------------------------------------------------
		# Faccio l'input per la sysrecord:
		#---------------------------------------------------------------------------
		#if (is_object($this->m_sysrecord))
		#	$this->m_sysrecord->loadInput(null, $messaggio, null, "sys_", "");

		#---------------------------------------------------------------------------
		# Per ogni campo cerco un input:
		#---------------------------------------------------------------------------
		foreach($oggetto->campi() as $chiave => $campo) {

			if ($chiave == $this->m_identity) # non indispensabile, ma per sicurezza...
				continue;

			if ($this->checkCampo($chiave) == false) { # non indispensabile, ma per sicurezza...
				#echo "checkCampo($chiave) = false<br>";
				#DEBUG("------------------------------- $chiave");
				continue;
			}

			# SE NON VISIBILE O NON MODIFICABILE LO IGNORO:
			if (!$campo->isVisibile($ruolo->bit()) || !$campo->isModificabile($ruolo->bit()))
				continue;

			# Se e' un oggetto, leggo i dati:
			if (strlen($campo->classe()) > 0) {
				if (class_exists($campo->classe())) {
					$classe = $campo->classe();

					# se siamo in update l'oggetto esiste gia':
					if (is_object($this->get($campo->code()))) {
						$o = $this->get($campo->code());
					}
					else {
						$o = new $classe();
						if (strlen($this->get($campo->code())) > 0)
							$o->loadFromCode($this->get($campo->code()));
						else
							$o->init();
					}
					$res_subobj = $o->loadInput($o->metainfo(), $messaggio, null, $pre.$campo->code().$post, "");
					if (!$res_subobj) {
						#echo $campo->code()." = FALSE!<br>";
						#echo "Messaggio = ".$messaggio->messaggio();
						$res = FALSE;
					}
					# QUI SIAMO OK!

					# SOLO per gli allegati, NON dobiamo associare l'oggetto se VUOTO:
					if (strtoupper($campo->classe()) == "ALLEGATO") {
						if (strlen($o->get("originale")) > 0)
							$this->set($chiave, $o);
						continue;
					}

					$this->set($chiave, $o);
					continue;
				}
			}

			#DEBUG($chiave.'='.$this->m_tipi[$chiave]);
			if (array_key_exists($pre.$chiave.$post, $_POST)) {
				switch($this->m_tipi[$chiave]) {
					case "timestamptz":
					case "datetime":
						$valore = getVar("POST", $pre.$chiave.$post, false);
						if (($valore !== false) && (strlen($valore) > 0)) {
							#$data = new myDate();
							#$data->setDate($valore, 'it');
							#$valore = $data->stampa('us')." 00:00:00";
							$valore = date_translate($valore, 'it', 'us')." 00:00:00";
						}
						break;

					case "real":
						$valore = getVar("POST", $pre.$chiave.$post, false);
						if (strlen($valore) > 0)
							$valore = write_number($valore, false);
						break;

					default:
						$valore = getVar("POST", $pre.$chiave.$post, false);
						break;
				}
			}
			else
				continue;

			#echo $pre.$chiave.$post."<br>";
			if ($valore === false)
				continue;
			if (!$campo->isVisibile($ruolo->bit()))
				continue;
			if (!is_null($voce_tipologia))
				if (!$voce_tipologia->isPresente('V', $campo->code()))
					continue;
			#DEBUG("*** ".get_class($this).":: ".$chiave." = |".$valore."|");
			$this->set($chiave, $valore);

			if (strlen($valore) == 0) {
				if (!is_null($voce_tipologia)) {
					if ($voce_tipologia->isPresente('V', $campo->code()) && $voce_tipologia->isPresente('O', $campo->code())) {
						$messaggio->setTipo(MSG_ERROR);
						$messaggio->setMessaggio("ATTENZIONE!<br />E' necessario valorizzare tutti i campi obbligatori. ({$campo->label(0)})");
						$res = false;
					}
				}
				else {
					if ($campo->isVisibile($ruolo->bit()) &&
							$campo->isObbligatorio($ruolo->bit()) &&
							$campo->isModificabile($ruolo->bit())) {
						$messaggio->setTipo(MSG_ERROR);
						$messaggio->setMessaggio("ATTENZIONE! E' necessario valorizzare tutti i campi obbligatori. (".$campo->label(0).")");
						$res = false;
					}
					/*echo "NO".$ruolo->bit().
						"-".$campo->isVisibile($ruolo->bit()).
						"-".$campo->isObbligatorio($ruolo->bit()).
						"-".$campo->isModificabile($ruolo->bit());*/
				}
			}
			#echo "<br><br>";
		}
		#die();
		return $res;
	}

	public function checkObbligatori($messaggio) {
		GLOBAL $metautente;

		if (is_object($this->metainfo()))
			$oggetto = $this->metainfo();

		$ruolo = $metautente->ruolo();
		$res = true;

		if (strlen($this->m_codice_tipologia) > 0) {
			if (is_object($this->m_voce_tipologia)) {
				$vocetipologia = $this->m_voce_tipologia;
			}
			else {
				$vocetipologia = new MetaVoceTipologia();
				$vocetipologia->load($this->m_codice_tipologia);
				$this->m_voce_tipologia = $vocetipologia;
				$this->updateMetaInfo();
			}
		}

		#---------------------------------------------------------------------------
		# Per ogni campo:
		#---------------------------------------------------------------------------
		foreach($oggetto->campi() as $chiave => $campo) {

			if ($chiave == $this->m_identity) # non indispensabile, ma per sicurezza...
				continue;

			if ($this->checkCampo($chiave) == false) { # non indispensabile, ma per sicurezza...
				#echo "checkCampo($chiave) = false<br>";
				#DEBUG("------------------------------- $chiave");
				continue;
			}

			# SE NON VISIBILE O NON MODIFICABILE LO IGNORO:
			if (!$campo->isVisibile($ruolo->bit()) || !$campo->isModificabile($ruolo->bit()))
				continue;

			$valore = $this->get($chiave);

			if (strlen($valore) == 0) {
				if (!is_null($voce_tipologia)) {
					if ($voce_tipologia->isPresente('V', $campo->code()) && $voce_tipologia->isPresente('O', $campo->code())) {
						$messaggio->setTipo(MSG_ERROR);
						$messaggio->setMessaggio("ATTENZIONE!<br />E' necessario valorizzare tutti i campi obbligatori. ({$campo->label(0)})");
						$res = false;
					}
				}
				else {
					if ($campo->isVisibile($ruolo->bit()) &&
							$campo->isObbligatorio($ruolo->bit()) &&
							$campo->isModificabile($ruolo->bit())) {
						$messaggio->setTipo(MSG_ERROR);
						$messaggio->setMessaggio("ATTENZIONE! E' necessario valorizzare tutti i campi obbligatori. (".$campo->label(0).")");
						$res = false;
					}
				}
			}
		}

		return $res;
	}

	################################################
	# QUOTA.
	private function quota($chiave) {
		$chiave = strtolower($chiave);

		if (is_object($this->m_campi[$chiave]))
			$this->m_campi[$chiave] = $this->m_campi[$chiave]->code();

		#echo $chiave."=".$this->m_tipi[$chiave]."<br>";
		switch($this->m_tipi[$chiave]) {
			case "int4":
			case "int":
			case "real":
				return write_number($this->m_campi[$chiave], true);
				break;

			case "timestamptz":
			case "datetime":
				if ($this->m_campi[$chiave] == "getdate()")
					return "getdate()";
				# TODO : check della data ed eventuale encode/decode.
				$data = $this->m_campi[$chiave];
				/*if (check_date_format($data, 'it'))
					return "CONVERT (datetime, ".quote_string($data, true).", 103)"; # 103=dd/mm/yyyy
				else
					return quote_string($data, true);*/
				if (check_date_format($data, 'it'))
					return quote_string($data, true);
				else
					return "CONVERT (datetime, ".quote_string($data, true).", 120)"; # 120=yyyy-mm-dd hh:mi:ss
				break;

			case "char":
			default:
				/*if ($this->m_dimensioni[$chiave] < 255)
					return quote_string(substr($this->m_campi[$chiave], 0, $this->m_dimensioni[$chiave]), true);
				else
					return quote_string($this->m_campi[$chiave], true);*/
								
				# TODO: verificare perche' alcuni oggetti (metautente) hanno dim=0!!!
				if ($this->m_dimensioni[$chiave] > 0)
					$this->m_campi[$chiave] = substr($this->m_campi[$chiave], 0, $this->m_dimensioni[$chiave]);
				return quote_string($this->m_campi[$chiave], true);
				
				break;
		}
	}

	################################################
	# CHECK.
	public function check($messaggio=null) {
		if (is_null($messaggio))
			$messaggio = $this->m_last_message;

		if (!is_object($messaggio))
			$messaggio = new Messaggio();

		return true;
	}
	public function checkQuery($query, $db2=null, $messaggio=null) {
		GLOBAL $db;

		/*if (is_null($messaggio))
			$messaggio = $this->last_messaggio;

		if (!is_object($messaggio))
			$messaggio = new Messaggio();
		 */
		#if (is_null($db2))
		#	$db2 = $db;

		if (!is_object($db2)) {
			$db2 = new DB();
			$rs = $db2->Connetti();

			$host = $db2->get("host");
			$user = $db2->get("user");
			$database = $db2->get("database");

			if ($rs == FALSE) {
				$messaggio->setTipo(MSG_ERROR);
				$messaggio->setMessaggio("Impossibile eseguire le verifiche sui dati.<br>Prego contattare l'amministratore del servizio.",
															"<br>".$db2->ErrorMsg());
				$db->Logga(LOGERROR, get_class($this)."::check()", "Collegamento al db $host.$database.$user fallito (".$db2->ErrorMsg().")");
				return FALSE;
			}
			else
				$db->Logga('DEBUG', get_class($this)."::check()", "Collegamento al db $host.$database.$user OK.");
		}

		$rs = $db2->Esegui($query, true, "DB2::".get_class($this)."::check()");

		if ($rs != false) {
			$res = true;
			$msg = "";
			$tipo = MSG_INFO;

			while (!$rs->EOF) {
				$codice = intval($rs->Fields("codice"));

				#DEBUG($codice." - ".$rs->Fields("errore"));
				if ($codice > 0)
					$tipo = MSG_ERROR;
				if ($codice < 0 && $tipo != MSG_ERROR)
					$tipo = MSG_WARNING;
				if ($codice != 0) {
					$msg .= "<p>".$rs->Fields("errore")."</p>";
					$res = FALSE;
				}
				$rs->MoveNext();
			}
			$messaggio->setTipo($tipo);
			$messaggio->setMessaggio($msg);
			if (strlen($msg) == 0)
				$msg = "nessuno.";
			$db->Logga('DEBUG', "DB2::".get_class($this)."::check()", "SQL:<br>$query<br>Messaggi ritornati:<br>$msg");
		}
		else {
			$messaggio->setTipo(MSG_ERROR);
			$messaggio->setMessaggio("Errore durante l'esecuzione della procedura di check! Impossibile continuare.<br>Contattare gli amministratori.");
			$db->Logga(LOGERROR, get_class($this)."::check()<br>SP FALLITA!", "$query<br>".$db2->ErrorMsg()."");
			$res = FALSE;
		}

		return $res;
	}

	################################################
	# UPDATE.
	public function update() {
		GLOBAL $db, $metautente;

		$this->m_last_query = "";
		if ($this->m_changed == false)
			return true;
		if (is_null($db) || (strlen($this->m_identity) <= 0) || ($this->m_campi[$this->m_identity] <= 0))
			return false;

		$this->m_last_action = 'U';

		#---------------------------------------------------------------------------
		# CHECK
		#---------------------------------------------------------------------------
		if ($this->m_eludi_check)
			$this->setEludiCheck(false);
		elseif ($this->check($this->m_last_message) !== true) {
			$db->FailTrans();
			$db->Logga(LOGWARNING, "", "<b>".get_class($this)."::Update-CHECK(): ".$this->m_last_message->messaggio()."</b>");
			return false;
		}

		if (strlen($this->get("code")) <= 0)
			$this->set("code", get_class($this).substr(md5(microtime()), rand(0, 16), 16));

		$strSQL1 = "UPDATE ".$this->m_tabella." SET  ";
		$strSQL2 = $strSQL3 = "  ";

		foreach($this->m_campi as $chiave => $campo) {
			if ($chiave == $this->m_identity) # non indispensabile, ma per sicurezza...
				continue;

			$oggetto = $this->metainfo();
			if (is_object($oggetto)) {
				$metacampo = $oggetto->campo($chiave);

				# Se e' un oggetto:
				if (strlen($metacampo->classe()) > 0) {
					if (class_exists($metacampo->classe())) {
						$classe = $metacampo->classe();
						$o = new $classe();

						# se l'oggetto HA una sua funzione di insert/update:
						if ($o->ownSave()) {
							if (is_object($campo))
								$o = $campo;
							elseif (strlen($campo) > 0)
								$o->loadFromCode($campo);
							else
								$o->init();
							if ($o->isChanged()) {
								if (strlen($o->code()) > 0)
									$res = $o->update();
								else
									$res = $o->insert();
								$this->m_campi_changed[$chiave] = true;
								$strSQL2 .= $chiave."=".quote_string($o->code()).", ";
							}
							else
								$res = true;
							$this->m_last_query .= get_class($campo)."::".$o->lastQuery()."<br>";
							if (!$res)
								return FALSE;

							continue;
						}
					}
				}
			}
			#DEBUG($chiave."=".$this->quota($chiave));
			if ($this->m_campi_changed[$chiave] == false)
				continue;

			$strSQL2 .= $chiave."=".$this->quota($chiave).", ";
		}
		$strSQL2 = substr($strSQL2, 0, -2); # tolgo l'ultima virgola.
		$strSQL3 .= " WHERE {$this->m_identity}=".$this->quota($this->m_identity).";";

		$res1 = $res2 = true;
		#-------------------------------------------------------------
		$db->StartTrans();
		if (strlen($strSQL2) > 0) {
			$res1 = $db->Esegui($strSQL1.$strSQL2.$strSQL3);
			$this->m_last_query .= $strSQL1.$strSQL2.$strSQL3."<br>";
		}

		if (strlen($this->code()) > 0 && $this->isChanged()) {
			#$sysrecord = Factory::crea("SYSRecord", $this->code());
			$sysrecord = $this->sysrecord();

			if (strlen($sysrecord->code()) == 0) {
				$sysrecord->set("code", $this->code());
				$sysrecord->set("tabella", $this->m_tabella);
			}

			$res2 = Factory::salva($sysrecord);
		}
		#$res = $res1;# && $res2; (ci interessa RES1, RES2 e' un di piu'...)
		$res = $db->CompleteTrans();

		#-------------------------------------------------------------
		#if ($res1 == FALSE)
		#	$db->Logga(LOGERROR, get_class($this)."::update()", $this->m_last_query);
		#if ($res2 == FALSE)
		#	$db->Logga(LOGERROR, get_class($sysrecord)."::salva()", $sysrecord->lastQuery());

		return $res;
	}

	################################################
	# INSERT.
	################################################
	/**
	 * inserisce un nuovo record.
	 *
	 * @return string|bool Ritorna il CODE del nuovo record o FALSE.
	 *
	 */
	public function insert() {
		GLOBAL $db, $metautente;

		#DEBUG("INSERT::".get_class($this));
		if (is_null($db) || (strlen($this->m_identity) <= 0))
			return false;

		# genero il CODE:
		if (strlen($this->get("code")) <= 0)
			$this->set("code", substr(strtoupper(get_class($this).substr(md5(microtime()), rand(0, 8), 24)), 0, 50));

		$this->m_last_action = 'I';

		#---------------------------------------------------------------------------
		# CHECK
		#---------------------------------------------------------------------------
		if ($this->m_eludi_check)
			$this->setEludiCheck(false);
		elseif ($this->check($this->m_last_message) !== true) {
			$db->FailTrans();
			$db->Logga(LOGWARNING, "", "<b>".get_class($this)."::Insert-CHECK(): ".$this->m_last_message->messaggio()."</b>");
			return false;
		}

		$strSQL = "INSERT INTO ".$this->m_tabella." (";

		foreach($this->m_campi as $chiave => $campo) {
			if ($chiave == $this->m_identity)
				continue;
			#if ($this->m_campi_changed[$chiave] == false) # in insert non serve, anzi.....
			#	continue;
			elseif (is_object($campo)) {
				$strSQL .= $chiave.", ";
			}
			elseif (strlen($this->m_campi[$chiave]) == 0)
				continue;
			else
				$strSQL .= $chiave.", ";
		}
		$strSQL = substr($strSQL, 0, -2); # tolgo l'ultima virgola.
		$strSQL .= ") VALUES (";

		foreach($this->m_campi as $chiave => $campo) {
			if ($chiave == $this->m_identity)
				continue;
			#if ($this->m_campi_changed[$chiave] == false)
			#	continue;

			# Se e' un oggetto, leggo i dati:
			elseif (is_object($campo)) {
				$res = $campo->insert();

				if (!$res)
					return FALSE;
				$strSQL .= "'".$campo->code()."', ";
			}
			elseif (strlen($this->m_campi[$chiave]) == 0)
				continue;
			else
				$strSQL .= $this->quota($chiave).", ";
		}
		$strSQL = substr($strSQL, 0, -2); # tolgo l'ultima virgola.
		$strSQL .= ")";
		#--------------------------------------------------------------

		/*if (strlen($this->code()) > 0) {
			$sysrecord = Factory::crea("SYSRecord");
			if (strlen($sysrecord->code()) == 0) {
				$sysrecord->set("code", $this->code());
				$sysrecord->set("tabella", $this->m_tabella);
			}
		}*/

		$sysrecord = $this->sysrecord();

		#--------------------------------------------------------------
		$db->StartTrans(); # <-- INIZIO TRANSAZIONE.
		$res = $db->Esegui($strSQL);
		$res2 = Factory::salva($sysrecord);
		$res = $db->CompleteTrans(); # <-- FINE TRANSAZIONE.
		#--------------------------------------------------------------

		#$this->m_last_query = "<br>INSERT #1: $strSQL<br>";
		#if ($res2 == FALSE)
		#	$this->m_last_query .= "<br>INSERT #2: ".$sysrecord->lastQuery();

		if ($res != false) {
			$strSQL3 = "SELECT {$this->m_identity} FROM {$this->m_tabella} WHERE code=".quote_string($this->code(), true);
			$rs = $db->Esegui($strSQL3);

			if ($rs != FALSE) {
				$this->set($this->m_identity, $rs->Fields($this->m_identity));
				Factory::attesa($this);
			}
		}

		#--------------------------------------------------------------

		return $res;
	}
	################################################
	# DELETE.
	################################################
	public static function delete($code) {
		GLOBAL $db, $metautente;

		if (strlen($code) > 0) {
			$strSQL = "UPDATE sys_record set ud=".quote_string($metautente->username, true).
								", td=getdate(), attivo='N' WHERE code=".quote_string($code, true);
			return $db->Esegui($strSQL);
		}
		return false;
	}

	public function invalidate($delete=true) {
		GLOBAL $db, $metautente;

		$this->m_last_action = 'D';

		$db->StartTrans();
		if ($delete) {
			$strSQL = "DELETE FROM sys_record WHERE code=".quote_string($this->get("code"), true);
			$rs = $db->Esegui($strSQL);
			$this->m_last_query = $strSQL."<br>";
			$strSQL = "DELETE FROM ".$this->m_tabella." WHERE code=".quote_string($this->get("code"), true);
			$rs = $db->Esegui($strSQL);
			$this->m_last_query = $strSQL."<br>";
			$strSQL = "DELETE FROM sys_relazioni WHERE code_figlio=".quote_string($this->get("code"), true);
		}
		else {
			$this->m_last_query = "";
			$strSQL = "UPDATE sys_record set ud=".quote_string($metautente->username, true).
								", td=getdate(), attivo='N' WHERE code=".quote_string($this->get("code"), true);
		}

		$this->m_last_query .= $strSQL."<br>";
		$db->Esegui($strSQL);

		$res = $db->CompleteTrans();
		return $res;
	}

	################################################
	# CLONA.
	################################################
	/**
	 * Fa una copia dell'oggetto corrente in un altro oggetto.
	 *
	 * @return object Ritorna l'oggetto clonato.
	 *
	 */
	public function clona() {
		$this->set($this->m_identity, "");
		$this->set("code", "");

		foreach($this->m_campi_changed as $chiave => $valore) {
			$this->m_campi_changed[$chiave] = true;
		}

		$this->m_changed = true;

		/*$clonato = Factory::crea(get_class($this), $this->code());

		$clonato->set($this->m_identity, "");
		$clonato->set("code", "");

		$oggetto = $this->metainfo();

		foreach($oggetto->campi() as $chiave => $campo) {
			if (strlen($campo->classe()) > 0) {
				# se e' una classe
				if (class_exists($campo->classe())) {
					$clonato->set($campo->code(), "");
				}
			}
		}

		#--------------------------------------------------------------

		return $clonato;*/
	}

	################################################
	# updateMetaInfo.
	public function updateMetaInfo() {
		GLOBAL $metautente;

    if (!is_object($this->m_voce_tipologia))
			return false;

		$oggetto = $this->metainfo();
		$voce = $this->m_voce_tipologia;

		# Sovrascrivo i permessi:
		foreach($oggetto->campi() as $campo) {
   		if (!$voce->isPresente('V', $campo->code())) {
				$campo = $this->m_metainfo->campo($campo->code());
				$campo->setVisibile(0);
				$this->m_metainfo->setCampo($campo->code(), $campo);
			}
			if ($voce->isPresente('O', $campo->code()))
				$this->metainfo()->campo($campo->code())->setObbligatorio($campo->obbligatorio() | pow(2, $metautente->ruolo()->bit()));
		}
		return true;
	}

	################################################
	# notifica.
	public function notifica() {
		return true;
	}

	################################################
	# DISPLAY.
	################################################
	# - vocetipologia : codice dell'eventuale tipologia da mostrare
	# - pre : stringa da anteporre al nome di default
	# - post : stringa da posporre al nome di default
	# - readonly : se l'oggetto deve essere di pura visualizzazione
	# - fase : eventuale fase (parte) dell'oggetto da visualizzare
	################################################
	public function display($vocetipologia="", $pre="", $post="", $readonly=false, $fase=0) {
		GLOBAL $smarty, $metautente, $db;

		$HTML = new UtilsHtml();
		$HTML->setPrePost($pre, $post);
		$HTML->setReadonly($readonly);

		if (strlen($this->m_codice_classe) == 0)
			return false;

		$oggetto = & $this->metainfo();

		if (strlen($vocetipologia) > 0) {
			$voce = new MetaVoceTipologia();
			$voce->load($vocetipologia);
			$this->m_voce_tipologia = $voce;

 			$this->updateMetaInfo();
		}

		#DEBUG(get_class($this)."::Display()=".$readonly);

		#--------------------------------------------------------------------------------------------------------
		# Funzioni JAVASCRIPT
		#--------------------------------------------------------------------------------------------------------
		if (strlen($this->m_campo_tipologia) > 0) {
			$metatipologia = new MetaTipologia();
			$metatipologia->loadFromCode($this->m_codice_tipologia);
			$metatipologia->loadVoci();

			$smarty->assign("tipologia", $metatipologia);
			$smarty->assign("oggetto", $this->metainfo());
			$smarty->assign("campo_tipologia", $pre.$this->m_campo_tipologia.$post);
			$smarty->display("js_tipologia.inc");
		}

		$date = 0;

		echo "<table id='".$pre.$this->m_codice_classe.$post."' border='0' cellspacing='0' cellpadding='2'>\n";

		#--------------------------------------------------------------------------------------------------------
		# Qui disegno l'eventuale TIPOLOGIA
		if (strlen($this->m_campo_tipologia) > 0) {
			$campo = $oggetto->campo($this->m_campo_tipologia);

			echo "<tr id='div_{$campo->code()}'>\n<td class='nero dx grassetto' style='vertical-align:top;'>";
			$HTML->label($campo);
			echo "</td>\n<td class='sx'>";

			$HTML->combobox($campo, $this, $metatipologia->voci(), "onchange=\"onTipologia_change(this);\"");
			echo "</td></tr>\n\n";
		}

		#--------------------------------------------------------------------------------------------------------
		# Per OGNI CAMPO
		foreach($oggetto->campi() as $campo) {
			# la tipologia l'ho gia' disegnata
			if ($campo->code() == $this->m_campo_tipologia)
				continue;

			# Se e' indicata una voce PRECISA, devo considerare quella:
			if (isset($voce)) {
				if (!$voce->isPresente('V', $campo->code())) {
					#echo $campo->code()." NON e' visibile<br>";
					continue;
				}
			}
			elseif (!$campo->isVisibile($metautente->ruolo()->bit())) {
				continue;
			}

			#------------------------------------------------------
			# Se e' un oggetto, lo disegno:
			if (strlen($campo->classe()) > 0) {
				echo "<tr id='div_{$campo->code()}' class=''>\n<td class='nero dx grassetto' style='vertical-align:top;'>";
				$HTML->label($campo);
				echo "</td>\n<td class='sx'>";

				# se e' una classe
				if (class_exists($campo->classe())) {
					$classe = $campo->classe();
					$o = new $classe();

					if (is_object($this->get($campo->code())))
						$o = $this->get($campo->code());
					elseif (strlen($this->get($campo->code())) > 0)
						$o->loadFromCode($this->get($campo->code()));
					else
						$o->init();

					$o->display(null, $pre.$campo->code().$post, "", $readonly);
				}
				else {
					# provo a caricare un oggetto per il codice:
					$mo = Factory::crea("MetaOggetto", $campo->classe(), true);
					if ($mo->id() > 0) {
						$classe = $mo->phpClasse();
					}
					if (class_exists($classe)) {
						$o = new $classe();
						if (strlen($this->get($campo->code())) > 0)
							$o->loadFromCode($this->get($campo->code()));
						else
							$o->init();
						$o->display(null, $pre.$campo->code().$post, "", $readonly);
					}
					else {
						# dovrebbe essere una tipologia semplice:
						$o = new MetaTipologia();
						$o->loadFromCode($campo->classe());
						$o->loadVoci();
						$o->display(null, $pre, $post, $campo, $this, $readonly);
					}
				}

				echo "</td></tr>\n\n";
				continue;
			}
			#------------------------------------------------------
			# Se e' configurata una sorgente:
			elseif ((strlen($campo->procedura()) > 0) && (strlen($campo->rsCodice()) > 0) && (strlen($campo->rsLabel()) > 0)) {
				echo "<tr id='div_{$campo->code()}' class=''>\n<td class='nero dx grassetto' style='vertical-align:top;'>";
				$HTML->label($campo);
				echo "</td>\n<td class='sx'>";

				$strSQL = $campo->procedura()." ".decodifica_filtri_dinamici($campo->parametri());
				$rs = $db->Esegui($strSQL);

				if (getVar("GET", "debug", 0))
					DEBUG($strSQL);

				if ($rs != FALSE) {
					$recordset = array();
					if (!$campo->isObbligatorio($metautente->ruolo()->bit()))
						$recordset[''] = '';
					while (!$rs->EOF) {
						$recordset[$rs->Fields($campo->rsCodice())] = $rs->Fields($campo->rsLabel());
						$rs->MoveNext();
					}
					$HTML->combobox($campo, $this, $recordset);
				}
 				else
					echo "<span class='grassetto rosso'>IMPOSSIBILE CONTATTARE LA SORGENTE DEI DATI. Contattare gli amministratori del servizio.</span>";
				echo "</td></tr>\n\n";
				continue;
			}
			#------------------------------------------------------
			echo "<tr id='div_{$campo->code()}' class=''>\n<td class='nero dx grassetto' style='vertical-align:top;'>";
			$HTML->label($campo);
			echo "</td>\n"."<td class='sx'>";

			if ($readonly) {
				switch($this->tipo($campo->code())) {
					case "datetime":
						#echo date_translate($this->get($campo->code()), 'us', 'it');
						$HTML->printReadonlyValue(date_translate($this->get($campo->code()), 'us', 'it'));
						break;

					case "int":
					case "real":
					case "char":
					default:
						#echo $this->get($campo->code());
						$HTML->printReadonlyValue($this->get($campo->code()));
						break;
				}
			}
			else {
				switch($this->tipo($campo->code())) {
					case "int":
					case "real":
						$HTML->input($campo, $this, "size='10'");
						break;

					case "datetime":
						$HTML->data($campo, $this, "cal".($date++));
						break;

					case "char":
					default:
						if ($this->dimensioni($campo->code()) > 50)
							$HTML->textarea($campo, $this, 4, 50);
						else
							$HTML->input($campo, $this);
						break;
				}
			}
			echo "</td></tr>\n\n";
		}
		echo "</table>\n";
	}

	public function debug() {
		$i=0;
		echo "<table cellpadding=2px cellspacing=1 style='font-size:0.7em;'><tr style='background:#333; color:white;'>";
		echo "<td>Campo</td>";
		echo "<td>Valore</td>";
		echo "<td>Tipo</td>";
		echo "<td>Dimensione</td>";
		echo "</tr>\n";

		foreach ($this->m_campi as $key => $valore) {
			$background = ($i % 2) ? "silver" : "white";
			echo "<tr style='background:{$background}'>";
			echo "<td style='font-weight:bold;color:#369;'>$key</td>";
			echo "<td>$valore</td>";
			echo "<td>".$this->m_tipi[$key]."</td>";
			echo "<td>".$this->m_dimensioni[$key]."</td>";
			echo "</tr>\n";
			$i++;
		}
		echo "</table>";

		return true;
	}
}
?>